/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicToolTipUI
extends ToolTipUI {
    static BasicToolTipUI sharedInstance = new BasicToolTipUI();
    private static PropertyChangeListener sharedPropertyChangedListener;
    private PropertyChangeListener propertyChangeListener;

    private void componentChanged(JComponent jComponent) {
        JComponent jComponent2 = ((JToolTip)jComponent).getComponent();
        if (jComponent2 != null && !jComponent2.isEnabled()) {
            if (UIManager.getBorder("ToolTip.borderInactive") != null) {
                LookAndFeel.installBorder(jComponent, "ToolTip.borderInactive");
            } else {
                LookAndFeel.installBorder(jComponent, "ToolTip.border");
            }
            if (UIManager.getColor("ToolTip.backgroundInactive") != null) {
                LookAndFeel.installColors(jComponent, "ToolTip.backgroundInactive", "ToolTip.foregroundInactive");
            } else {
                LookAndFeel.installColors(jComponent, "ToolTip.background", "ToolTip.foreground");
            }
        } else {
            LookAndFeel.installBorder(jComponent, "ToolTip.border");
            LookAndFeel.installColors(jComponent, "ToolTip.background", "ToolTip.foreground");
        }
    }

    private void installComponents(JComponent jComponent) {
        BasicHTML.updateRenderer(jComponent, ((JToolTip)jComponent).getTipText());
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        this.componentChanged(jComponent);
    }

    protected void installListeners(JComponent jComponent) {
        this.propertyChangeListener = this.createPropertyChangeListener(jComponent);
        jComponent.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installComponents(jComponent);
        this.installListeners(jComponent);
    }

    private void uninstallComponents(JComponent jComponent) {
        BasicHTML.updateRenderer(jComponent, "");
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    protected void uninstallListeners(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
        this.uninstallComponents(jComponent);
        this.uninstallListeners(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null || string.equals("")) {
            string = "";
        } else {
            View view;
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                dimension.width += (int)view.getPreferredSpan(0);
                dimension.height += (int)view.getPreferredSpan(1);
            } else {
                dimension.width += SwingUtilities.computeStringWidth(fontMetrics, string) + 6;
                dimension.height += fontMetrics.getHeight();
            }
        }
        return dimension;
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        if (sharedPropertyChangedListener == null) {
            sharedPropertyChangedListener = new PropertyChangeHandler(null);
        }
        return sharedPropertyChangedListener;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension dimension = jComponent.getSize();
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        graphics.setColor(jComponent.getForeground());
        graphics.setFont(font);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            graphics.drawString(string, rectangle.x + 3, rectangle.y + fontMetrics.getAscent());
        }
    }

    static void access$100(BasicToolTipUI basicToolTipUI, JComponent jComponent) {
        basicToolTipUI.componentChanged(jComponent);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    static class 1 {
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JToolTip jToolTip;
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("tiptext") || "font".equals(string) || "foreground".equals(string)) {
                JToolTip jToolTip2 = (JToolTip)propertyChangeEvent.getSource();
                String string2 = jToolTip2.getTipText();
                BasicHTML.updateRenderer(jToolTip2, string2);
            } else if ("component".equals(string) && (jToolTip = (JToolTip)propertyChangeEvent.getSource()).getUI() instanceof BasicToolTipUI) {
                BasicToolTipUI.access$100((BasicToolTipUI)jToolTip.getUI(), jToolTip);
            }
        }

        PropertyChangeHandler(1 var1_1) {
            this();
        }
    }
}

